package models

import (
	"github.com/jmoiron/sqlx"
	"log"
	"net"
)

type ParseIpIps struct {
	Id      int    `db:"id"`
	Ip      string `db:"ip"`
}

type ListParseIpIps []ParseIpIps

func(a ListParseIpIps) difference(b []ParseIpIps) (diff []ParseIpIps) {
	m := make(map[string]bool)

	for _, item := range b {
		m[item.Ip] = true
	}

	for _, item := range a {
		if _, ok := m[item.Ip]; !ok {
			diff = append(diff, item)
		}
	}
	return diff
}

func BatchParseIpIps(ips []net.IP) []int{
	var ipsArg ListParseIpIps
	for _, ip := range ips {
		i := ParseIpIps{}
		i.Ip = ip.String()
		ipsArg = append(ipsArg, i)
	}

	ipsDb := getHavingIps(ipsArg)
	ipsDiff := ipsArg.difference(ipsDb)

	if ipsDiff != nil{
		return insertParseIpIp(ipsDiff)
	}

	return nil
}

func insertParseIpIp(ipsDiff []ParseIpIps) []int {
	rows, err := db.NamedQuery("INSERT INTO parse_ip_ips (ip) VALUES(:ip) RETURNING id", ipsDiff)
	if err != nil {
		log.Fatalln(err)
	}

	var ids []int
	for rows.Next() {
		var id int
		err := rows.Scan(&id)
		if err != nil {
			log.Fatalln(err)
		}

		ids = append(ids, id)
	}

	return ids
}

func getHavingIps(ipsArg []ParseIpIps) []ParseIpIps{
	query, args, err := sqlx.Named("SELECT * FROM parse_ip_ips where ip IN ((:ip))", ipsArg)
	if err != nil{
		log.Fatalln(err)
	}

	query, arg, err := sqlx.In(query, args...)
	if err != nil{
		log.Fatalln(err)
	}

	query = db.Rebind(query)
	rows, err := db.Queryx(query, arg...)
	if err != nil{
		log.Fatalln(err)
	}

	var ipsDb []ParseIpIps
	for rows.Next() {
		var ip ParseIpIps
		err = rows.StructScan(&ip)
		if err != nil{
			log.Fatalln(err)
		}
		ipsDb = append(ipsDb, ip)
	}

	return ipsDb
}